
<?php
function build_calendar($month,$year) {
    // Create array containing abbreviations of days of week.
    $daysOfWeek = array('S','M','T','W','T','F','S');

     // What is the first day of the month in question?
     $firstDayOfMonth = mktime(0,0,0,$month,1,$year);

     // How many days does this month contain?
     $numberDays = date('t',$firstDayOfMonth);

     // Retrieve some information about the first day of the
     // month in question.
     $dateComponents = getdate($firstDayOfMonth);

     // What is the name of the month in question?
     $monthName = $dateComponents['month'];

     // What is the index value (0-6) of the first day of the
     // month in question.
     $dayOfWeek = $dateComponents['wday'];

     // Create the table tag opener and day headers
     $calendar = "<table class='webcalendar' >";
     $calendar .= "<caption><a href=\"javascript:goToPage('frame_content','../events/read_month.php?year=$year&month=$month');\" style='COLOR:#000000; TEXT-DECORATION: none'><FONT SIZE =3><B>$monthName, $year</a></B></FONT></caption>";
     $calendar .= "<tr>";

     // Create the calendar headers

     foreach($daysOfWeek as $day) {
          $calendar .= "<th class='webheader' >$day</th>";
     }

     // Create the rest of the calendar
     // Initiate the day counter, starting with the 1st.
     $currentDay = 1;

     $calendar .= "</tr><tr>";

     // The variable $dayOfWeek is used to
     // ensure that the calendar
     // display consists of exactly 7 columns.
     if ($dayOfWeek > 0) {
          $calendar .= "<td colspan='$dayOfWeek'>&nbsp;</td>";
     }

     while ($currentDay <= $numberDays) {
          // Seventh column (Saturday) reached. Start a new row.
          if ($dayOfWeek == 7) {
               $dayOfWeek = 0;
               $calendar .= "</tr><tr>";
          }

         // Is the $currentDay a member of $dateArray? If so,
         // the day should be linked.
         $todayDay = date("j");
         $todayMonth = date("m");
         $todayYear = date("Y");

         $date_p = "$year-$month-".substr(($currentDay+100),-2);
        //Get Event Data
         $query = "SELECT event_id,
                   DATE_FORMAT(event_start_date,'%d %M %Y') AS event_start_date,
                   DATE_FORMAT(event_end_date,'%d %M %Y') AS event_end_date
                   FROM tbl_event
                   WHERE DATE_FORMAT(event_start_date,'%Y-%c-%d')<=\"".$date_p."\"
                   AND DATE_FORMAT(event_end_date,'%Y-%c-%d')>=\"".$date_p."\";";
                   

              $result = mysqli_query($dbconn,$query) or die("Unable to get data! - Err msg ". mysqli_error($dbconn));
              $num_rows = mysqli_num_rows($result);
              //Event found
              
              if ($num_rows)
              {

                    if ($currentDay==$todayDay AND $month==$todayMonth AND $year==$todayYear )
                    {
                        $calendar .= "<td class='weblinkedtodaysmall' valign=top>";
                    }
                    else
                    {
                        $calendar .= "<td class='weblinkeddaysmall' valign=top >";
                    }
                    
                $calendar .= $currentDay;
                $calendar .="</td>";
            }
            // No Event
            else {
                    if ($currentDay==$todayDay AND $month==$todayMonth AND $year==$todayYear)
                    {
                        $calendar .= "<td class='webtodaysmall' valign=top>";
                    }
                    else
                    {
                        $calendar .= "<td class='webdaysmall' valign=top>";
                    }

               $calendar .= $currentDay."</td>";
              }

          $currentDay++;
          $dayOfWeek++;
      }

     // Complete the row of the last week in month, if necessary

     if ($dayOfWeek != 7) {
          $remainingDays = 7 - $dayOfWeek;
          $calendar .= "<td colspan='$remainingDays'>&nbsp;</td>";
     }
          $calendar .= "</table>";
     return $calendar;
}

?>

