<script language=javascript>

function showIconStatus2(id){
document.getElementById("cal_"+id).style.visibility="visible";
document.getElementById("cal_"+id).style.zIndex=1000;
}
function stopIconStatus2(id){
document.getElementById("cal_"+id).style.visibility="hidden";
}
</script>

<?php
function build_calendar($month,$year) {
    // Create array containing abbreviations of days of week.
    $daysOfWeek = array('Sun','Mon','Tue','Wed','Thu','Fri','Sat');

     // What is the first day of the month in question?
     $firstDayOfMonth = mktime(0,0,0,$month,1,$year);

     // How many days does this month contain?
     $numberDays = date('t',$firstDayOfMonth);

     // Retrieve some information about the first day of the
     // month in question.
     $dateComponents = getdate($firstDayOfMonth);

     // What is the name of the month in question?
     $monthName = $dateComponents['month'];

     // What is the index value (0-6) of the first day of the
     // month in question.
     $dayOfWeek = $dateComponents['wday'];

    //Get Weekend category code
    $query = "SELECT event_cat_id
              FROM tbl_event_category
              WHERE LOWER(event_cat_title)='weekend';";
    $result = mysqli_query($dbconn,$query) or die("Unable to get data! - Err msg ". mysqli_error($dbconn));
    $line = mysqli_fetch_array($result, MYSQL_ASSOC);
    if ($line){
      $weekendcode= $line['event_cat_id'];
    }

    //Get Holiday category code
    $query = "SELECT event_cat_id
              FROM tbl_event_category
              WHERE LOWER(event_cat_title)='public holiday';";
    $result = mysqli_query($dbconn,$query) or die("Unable to get data! - Err msg ". mysqli_error($dbconn));
    $line = mysqli_fetch_array($result, MYSQL_ASSOC);
    if ($line){
      $holidaycode= $line['event_cat_id'];
    }

     // Create the table tag opener and day headers
     $calendar = "<table class='webcalendar' width=440>";
     $calendar .= "<caption><a href='listing_events.php?year=$year&month=$month' style='COLOR:#000000; TEXT-DECORATION: none'><FONT SIZE =3><B>$monthName, $year</a></B></FONT></caption>";
     $calendar .= "<tr>";

     // Create the calendar headers

     foreach($daysOfWeek as $day) {
          $calendar .= "<th class='webheader' width=14%>$day</th>";
     }

     // Create the rest of the calendar
     // Initiate the day counter, starting with the 1st.
     $currentDay = 1;

     $calendar .= "</tr><tr>";

     // The variable $dayOfWeek is used to
     // ensure that the calendar
     // display consists of exactly 7 columns.
     if ($dayOfWeek > 0) {
          $calendar .= "<td colspan='$dayOfWeek'>&nbsp;</td>";
     }

     while ($currentDay <= $numberDays) {
          // Seventh column (Saturday) reached. Start a new row.
          if ($dayOfWeek == 7) {
               $dayOfWeek = 0;
               $calendar .= "</tr><tr>";
          }

         // Is the $currentDay a member of $dateArray? If so,
         // the day should be linked.
         $todayDay = date("j");
         $todayMonth = date("m");
         $todayYear = date("Y");

         $date_p = "$year-$month-".substr(($currentDay+100),-2);
         //Get Event Data
         $query = "SELECT event_id,
                   tbl_event.event_cat_id AS event_cat_id,
                   event_title,
                   DATE_FORMAT(event_start_date,'%d %M %Y') AS event_start_date,
                   DATE_FORMAT(event_end_date,'%d %M %Y') AS event_end_date,
                   event_detail,
                   tbl_user.user_full_name AS user_full_name,
                   tbl_event_category.event_icon_type AS cat_img,
                   tbl_event_category.event_cat_id AS cat_id
                   FROM tbl_event, tbl_user, tbl_event_category
                   WHERE DATE_FORMAT(event_start_date,'%Y-%c-%d')<=\"".$date_p."\"
                   AND DATE_FORMAT(event_end_date,'%Y-%c-%d')>=\"".$date_p."\"
                   AND tbl_event.creator_id = tbl_user.user_id
                   AND tbl_event.event_cat_id = tbl_event_category.event_cat_id;";

              $result = mysqli_query($dbconn,$query) or die("Unable to get data! - Err msg ". mysqli_error($dbconn));
              $num_rows = mysqli_num_rows($result);
              //Event found
              if ($num_rows)
              {
                $isholiday =0;
                $isweekend =0;
                $calendardiv = "";
                // Get Event Data
                while($line = mysqli_fetch_array($result, MYSQL_ASSOC))
                {
                  // Create DIV
                    $calendardiv .= "<tr><td align=left width=10%>";
                    if ($line['cat_img']!=""){
                        $calendardiv .= "<img class=image_frame src=image_event_icon.php?id=".$line['cat_id']." width=50>";
                    } else {
                        $calendardiv .= "<BR>";
                    }
                    $calendardiv .= "</td><td align=left width=80%>";
                    $calendardiv .= "<B>".$line['event_title']."</B><BR>";
                    $calendardiv .= "<B>".$line['event_start_date'];
                    if($line['event_start_date']!=$line['event_end_date']){
                        $calendardiv .= " to ".$line['event_end_date'];
                    }
                    $calendardiv .= "</B><BR>";
                    $calendardiv .= "By ".$line['user_full_name'];
                    $calendardiv .= "</td></tr>";
                    $calendardiv .= "<tr><td></td><td><hr></td></tr>";

                    //Check found holiday
                    if ($holidaycode==$line['event_cat_id'])
                    {
                        $isholiday =1;
                    }
                    //Check found weekend
                    if ($weekendcode==$line['event_cat_id'])
                    {
                        $isweekend =1;
                    }
                 }


                    if ($currentDay==$todayDay AND $month==$todayMonth AND $year==$todayYear )
                    {
                        $calendar .= "<td class='weblinkedtoday' valign=top onMouseOver='showIconStatus2($currentDay)' onMouseOut='stopIconStatus2($currentDay)'>";
                    }
                    //is today holiday
                    elseif ($currentDay==$todayDay AND $month==$todayMonth AND $year==$todayYear AND $isholiday==1)
                    {
                        $calendar .= "<td class='weblinkedtodayholiday' valign=top onMouseOver='showIconStatus2($currentDay)' onMouseOut='stopIconStatus2($currentDay)'>";
                    }
                    //is today weekend
                    elseif ($currentDay==$todayDay AND $month==$todayMonth AND $year==$todayYear AND $isweekend==1)
                    {
                        $calendar .= "<td class='weblinkedtodayweekend' valign=top onMouseOver='showIconStatus2($currentDay)' onMouseOut='stopIconStatus2($currentDay)'>";
                    }
                    //is other day holiday
                    elseif ($isholiday==1)
                    {
                        $calendar .= "<td class='weblinkeddayholiday' valign=top onMouseOver='showIconStatus2($currentDay)' onMouseOut='stopIconStatus2($currentDay)'>";
                    }
                    //is other day weekend
                    elseif ($isweekend==1)
                    {
                        $calendar .= "<td class='weblinkeddayweekend' valign=top onMouseOver='showIconStatus2($currentDay)' onMouseOut='stopIconStatus2($currentDay)'>";
                    }
                    else
                    {
                        $calendar .= "<td class='weblinkedday' valign=top onMouseOver='showIconStatus2($currentDay)' onMouseOut='stopIconStatus2($currentDay)'>";
                    }
                 if($currentDay>10){ $margin_set1="margin:-120px";}  
                	else{ $margin_set1="margin:10px";}
                	
                if($dayOfWeek>3){ $margin_set2="-300px;";}  
                else{ $margin_set2="60px;";}
                $calendar .= "<a href='listing_events.php?date=$date_p' class='webcalendarlink' ><font size=2><B>$currentDay</font><BR><BR></B></a>";
                $calendar .="<div id='cal_".$currentDay."' style='filter:alpha(opacity=80);-moz-opacity:.80;opacity:.80;position:absolute; left:?px; top:?px; width:?px; height:?px; z-index:150; visibility:hidden; $margin_set1 $margin_set2'>";
                $calendar .= "<table border=1 bordercolor=000000 cellspacing=0 bgcolor=e5f2ff width=300><tr><td><table border=0><tr><td>";
                $calendar .= $calendardiv;
                $calendar .="</td></td></table></td></tr></table>";
                $calendar .="</div>";
                $calendar .="</td>";
            }
            // No Event
            else {
                    if ($currentDay==$todayDay AND $month==$todayMonth AND $year==$todayYear)
                    {
                        $calendar .= "<td class='webtoday' valign=top>";
                    }
                    else
                    {
                        $calendar .= "<td class='webday' valign=top>";
                    }

               $calendar .= "<B><font size=2>$currentDay</font></B><br><br></td>";
              }

          $currentDay++;
          $dayOfWeek++;
      }

     // Complete the row of the last week in month, if necessary

     if ($dayOfWeek != 7) {
          $remainingDays = 7 - $dayOfWeek;
          $calendar .= "<td colspan='$remainingDays'>&nbsp;</td>";
     }
          $calendar .= "</table>";
     return $calendar;
}

?>

